	function [G, Z, R_ZEROS, P, Wsnew] = CH_I_POLES_S(Wc, Ws, Amax, Amin, N)
	
	% 	Computes the denormalized poles, zeros and gain constant for  
	%	an analog lowpass Chebyshev I filter with |H(jw)|max = 1.
	%	The design margin is used to decrease the stopband edge to Wsnew.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 1983-08-15
	% 	Modified by: 	LW,  1987-01-19, 2002-07-28, 2004-09-22, 2013-12-29
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	if floor(N) ~= -floor(-N)
		disp('N must be an interger')
		return
	end
	if ~(abs(N-round(N)) < eps)
		N = floor(CH_ORDER_S(Wc, Ws, Amax, Amin)) + 1;
	end
	if (Wc >= Ws)
		error('Not a lowpass filter. Must have Wc < Ws')  
	elseif ( Amax <= 0 | Amax >= Amin)
		error('The passband attenuation must be 0 < Amax < Amin')
	elseif ( Amin <= 0)
		error('The stopband attenuation must be Amin > Amax > 0')
	end 

	odd = rem(N, 2);
	if odd == 1
		M = (N+1)/2;  
	else
		M = N/2;
	end
	Apn = Amax*log(10)/20;
	epsilon2 = 2*exp(Apn)*sinh(Apn); % = sqrt(10^(Amax/10)-1)
	F = asinh(1/sqrt(epsilon2))/N;
	A = sinh(F); 
	B = cosh(F);
	Z = [];
	P = [];
	% Compute the normalized poles
	for k = 1:M
		v = (2*k-1)*pi/(2*N);
		if k == M & odd == 1 	% real pole
			P = [-A*sin(v);P];
		else
			X = -A*sin(v) + i* B*cos(v);
			P = [conj(X);X;P];
		end
	end  
	% Denormalized the poles
	P = Wc*P;
	% Gain constant
	G = real(prod(-P));
	if (~rem(N, 2)) 	% N is even, hence correct the gain 
		G = G/sqrt(1 + epsilon2);
	end

	X = acosh(sqrt((10^(0.1*Amin)-1)/(10^(0.1*Amax)-1)))/N;
	Wsnew = Wc*cosh(X);
	
	for k = 1:N
		R_ZEROS(k) = i*Wc*cos((2*k-1)*pi/2/N);
	end
	R_ZEROS = cplxpair(R_ZEROS)';
	% The attenuation at the stopband edge is
	% W = Ws/Wc;
	% Tx = cosh(N*log10(W + sqrt(W*W-1)));
	% AstopEdge = 10*log10(1 + epsilon2*Tx*Tx);
